####################
#  scanAFLP v1.1   #
####################

# This R script helps to score dominant markers such as AFLPs
# It is developped by Doris HERRMANN, Bndicte N. PONCET and Felix GUGERLI
# 2010/05/24 scanAFLP version 1.1
# For questions, comments or suggestions please contact B.N. PONCET (benedicte.poncet@e.ujf-grenoble.fr) or F. GUGERLI (felix.gugerli@wsl.ch)

scanAFLP<-function(infile) {
  read.table(infile,sep='\t',dec=".",header=T,na.strings="NA")->MATRIX
  read.table('parameters.txt',sep='\t',dec=".",header=T,na.strings="NA")->PARAM
  read.table('controls.txt',sep='\t',dec='.',header=T,na.strings="NA")->CONTROLS

#-------------------------------------------------------------------------------------------------------------------------
# Functions
#-------------------------------------------------------------------------------------------------------------------------

# Stats
Stats<-function(MAT) # matrix in 0/1 with sample.names in row.names
  {
  PREV<-colSums(MAT[,1:ncol(MAT)],na.rm=TRUE)/nrow(MAT) # prevalence of markers
  Mono<-(length(PREV[PREV==0]))+(length(PREV[PREV==nrow(MAT)])) # number of monomorphic markers
  Mono.names<-names(which(PREV==0)) # names of monomorphic markers
  
  IndMV<-c(); for (i in 1:ncol(MAT)) {IndMV<-c(IndMV,rownames(MAT)[is.na(MAT[,i])])}; IndMV
  Samples.MV<-unique(IndMV) # names of the samples with missing values (NA)
  
  Sizes<-c(); for (i in 1:ncol(MAT)) {c(Sizes,as.numeric((strsplit(as.character(colnames(MAT)[i]),split="_",fixed=T))[[1]][3]))->Sizes}; Sizes
  
  NbPeaks<-rowSums(MAT[,1:ncol(MAT)],na.rm=T)
  
  ST<-matrix(NA, nrow=17, ncol=1, dimnames=list(c('NbSamples','NbSamplesWithNA','NbMarkers','PrevMin','PrevMax','PrevMean',
  'NbMono','NbPoly','LengthMin','LengthMax','LengthMean','PrevLengthCorr','PrevLengthCorrPvalue','MinNbPeak',
  'MaxNbPeak','ProfilesWithoutPeaks','MeanNbPeak'),c('')))
  ST[1,1]<-nrow(MAT) # number of profiles stemming from GeneMapper  == NbP be careful of that
  ST[2,1]<-length(Samples.MV) # number of samples with missing values
  ST[3,1]<-ncol(MAT) # number of markers
  ST[4,1]<-min(PREV) # minimal prevalence of marker
  ST[5,1]<-max(PREV) # maximal prevalence of marker
  ST[6,1]<-mean(PREV) # mean prevalence of marker
  ST[7,1]<-Mono # number of monomorphic markers
  ST[8,1]<-ncol(MAT)-Mono # number of polymorphic markers
  ST[9,1]<-min(Sizes) # minimal length of marker (bases)
  ST[10,1]<-max(Sizes) # maximal length of marker (bases)
  ST[11,1]<-mean(Sizes) # mean length of marker (bases)
  ST[12,1]<-cor.test(Sizes,as.vector(PREV),method='pearson',na.action=na.omit)$estimate  # Pearson's product-moment correlation between sizes of markers and their prevalence 
  ST[13,1]<-cor.test(Sizes,as.vector(PREV),method='pearson',na.action=na.omit)$p.value   # P-value on the Pearson's product-moment correlation between sizes of markers and their prevalence 
  ST[14,1]<-min(NbPeaks) # minimal number of peaks per profile
  ST[15,1]<-max(NbPeaks) # maximal number of peaks per profile
  ST[16,1]<-length(NbPeaks[NbPeaks==0]) # number of profiles with no peak (samples that didn't work or negative controls)
  ST[17,1]<-mean(NbPeaks[NbPeaks=!0]) # mean of number of peaks per profile (without profiles with no peak) 
  
  list(ST,Samples.MV)
  }

# ErrorRate
ErrorRates<-function(MAT.ER, CONTROLS, PARAM, DeleteMarker=F, DeleteControls=T)
   {Samples<-rownames(MAT.ER)  
    noquote(as.vector(CONTROLS[CONTROLS[,1]=='duplicated',2]))->R # vector of sample names of duplicated samples   
    noquote(as.vector(CONTROLS[CONTROLS[,1]=='multiple',2]))->M # vector of sample names of multiple controls  
    noquote(as.vector(CONTROLS[CONTROLS[,1]=='negative',2]))->N # vector of sample names of negative controls
  
   as.numeric(as.vector(PARAM[(PARAM[,1]=='Duplicated_samples'),2]))->NbR
   if (NbR!=((length(R))/2)) {print('Error in number of duplicated samples')}
   as.numeric(as.vector(PARAM[(PARAM[,1]=='Multiple_controls'),2]))->NbM
   NbP<-(length(M))/NbM # number of plates
   if (NbM!=((length(M))/NbP)) {print('Error in number of multiple controls')}
   as.numeric(as.vector(PARAM[(PARAM[,1]=='Negative_controls'),2]))->NbN
   if (NbN!=length(N)) {print('Error in number of negative controls')}
    
   OutputErrorRates<-list() # List of details on error rates at each step
   # 1 error rate in duplicated samples
   # 2 error rate in multiple samples
   # 3 global error rate*
   # 4 nb removed markers according to repeatability of duplicated samples
   # 5 names of removed markers according to repeatability of duplicated samples
   # 6 nb removed markers according to repeatability in multiple controls
   # 7 names of removed markers according to repeatability in multiple controls
   # 8 nb removed markers according to negative controls
   # 9 names of removed markers according to negative controls
   # (*)  Calcul of global error rate : error rate in duplicated samples + error rate in multiple controls
   #      where error rate in duplicated samples is (sum of errors in all duplicated sample comparisons)/(number of markers*number of duplicated controls)
   #      and where error rate in multiple controls is (sum of errors in all multiple controls)/(number of markers*number of multiple controls)
   # 10 MAT.ER without problematic markers
   
   # errors allowed by the user
   as.numeric(as.vector(PARAM[(PARAM[,1]=='NC1'),2]))->Ndup
   as.numeric(as.vector(PARAM[(PARAM[,1]=='NC2'),2]))->Nmul
   as.numeric(as.vector(PARAM[(PARAM[,1]=='NC3'),2]))->Nneg
 
   # vector to keep or remove each marker
   Keep<-rep(T,ncol(MAT.ER))

   # 1/ Repeatability
   # 1.1/ duplicated samples
   if (NbR!=0) {
                Diff<-vector()
                for (i in seq.int(1,length(R),2)) {
                    DUP<-rbind(MAT.ER[Samples==(R[i]),],MAT.ER[Samples==(R[i+1]),])
                    colSums(DUP)->SumDup # Number of peaks in each marker present in all negative controls
                    Diff<-rbind(Diff,SumDup)
                    }

                 Diff[Diff==2]<-0

                 TXdup<-sum(rowSums(Diff))
                 ErrorRateDup<-TXdup/(2*NbR*ncol(MAT.ER))
                 OutputErrorRates[[1]]<-ErrorRateDup
                
                 colSums(Diff)->NbPeaksDup
                 NbRMdup<-length(NbPeaksDup[NbPeaksDup>Ndup]) # number of markers that will be removed because of more than NC1 presence(s) in all duplicated samples
                 OutputErrorRates[[4]]<-paste('Number of markers removed because of more than', Ndup, 'errors among',NbR,'duplicated samples:',NbRMdup,sep=' ')
                 OutputErrorRates[[5]]<-colnames(MAT.ER)[(NbPeaksDup>Ndup)] # names of markers that will be removed because of more than NC3 presence(s) in all negative controls
                 
                 for (k in 1:length(Keep)) {if (NbPeaksDup[k]>Ndup) {Keep[k]<-F}}
                 Keep
                }
    Keep
    
   # 1.2/ multiple controls
   if (NbM!=0) {
                DiffM<-vector()
                for (i in seq.int(1,length(M),NbP)) {
                    REPET<-vector()
                    for (m in 0:(NbP-1)) {REPET<-rbind(REPET,MAT.ER[Samples==(M[i+m]),])}
                    colSums(REPET)->SumMul # Number of peaks in each marker present in all negative controls
                    DiffM<-rbind(DiffM,SumMul)
                    }
                 DiffM

                 n<-NbP; l<-0
                 while (n>(NbP/2)) {DiffM[DiffM==n]<-(0+l); n<-n-1; l<-l+1}
                 DiffM
                                  
                 TXmul<-sum(rowSums(DiffM))
                 ErrorRateMul<-TXmul/(NbM*NbP*ncol(MAT.ER))
                 OutputErrorRates[[2]]<-ErrorRateMul
                 
                 colSums(DiffM)->NbPeaksMul
                 NbMMmul<-length(NbPeaksMul[NbPeaksMul>Nmul]) # number of markers that will be removed because of more than NC2 presence(s) in all replicated samples
                 OutputErrorRates[[6]]<-paste('Number of markers removed because of more than', Nmul, 'errors among',NbM,'replicated samples:',NbMMmul,sep=' ')
                 OutputErrorRates[[7]]<-colnames(MAT.ER)[(NbPeaksMul>Nmul)] # names of markers that will be removed because of more than NC3 presence(s) in all negative controls
                 
                 for (k in 1:length(Keep)) {if (NbPeaksMul[k]>Nmul) {Keep[k]<-F}}
                }
    Keep

   if ((NbR!=0)&(NbM!=0)) {OutputErrorRates[[3]]<-ErrorRateDup+ErrorRateMul}
   if ((NbR!=0)&(NbM==0)) {OutputErrorRates[[3]]<-ErrorRateDup}
   if ((NbR==0)&(NbM!=0)) {OutputErrorRates[[3]]<-ErrorRateMul}
   if ((NbR==0)&(NbM==0)) {OutputErrorRates[[3]]<-'NoData'}
  
    
   # 2/ Negative controls
   if (NbN!=0) {
                NEG<-vector()
                for (i in 1:NbN) {NEG<-rbind(NEG,MAT.ER[Samples==(N[i]),])}
                colSums(NEG)->NbPeaksNeg # Number of peaks in each marker present in all negative controls
                NbRMneg<-length(NbPeaksNeg[NbPeaksNeg>Nneg]) # number of markers that will be removed because of more than NC3 presence(s) in all negative controls
                OutputErrorRates[[8]]<-paste('Number of markers removed because of more than', Nneg, 'presence(s) in the', NbN, 'negative controls:',NbRMneg,sep=' ')
                OutputErrorRates[[9]]<-colnames(MAT.ER)[(NbPeaksNeg>Nneg)] # names of markers that will be removed because of more than NC3 presence(s) in all negative controls
                
                for (k in 1:length(Keep)) {if (NbPeaksNeg[k]>Nneg) {Keep[k]<-F}}
                Keep
                } 
    
    # To remove all controls except the first of each duplication of samples, except the first of multiple controls, and, all negative controls
    if (DeleteControls==T) {
                  if (NbR!=0) {DelControls1<-c(R[-(seq.int(1,length(R),2))])} else {DelControls1<-R}
                  if (NbM!=0) {DelControls2<-c(M[-(seq.int(1,length(M),NbP))])}  else {DelControls2<-M}
                  DelControls<-c(DelControls1,DelControls2,N)
                  for (v in 1:length(DelControls)) {MAT.ER[-which(rownames(MAT.ER)==DelControls[v]),]->MAT.ER}
                           
                  # Remove controls and remove markers according to allowed error tresholds setted in parameters.txt also if the argument Delete=T
                  if (DeleteMarker==T) {MAT.ER[,Keep]->MAT.ERn} else {MAT.ER->MAT.ERn}             
                           }

    # Keep controls but remove markers according to allowed error tresholds setted in parameters.txt only if the argument Delete=T            
    if (DeleteControls==F) {if (DeleteMarker==T) {MAT.ER[,Keep]->MAT.ERn} else {MAT.ER->MAT.ERn}}
   
    OutputErrorRates[[10]]<-MAT.ERn                       
    OutputErrorRates
    }

# RemoveEmptyMarker (i.e. columns with 0 only)
RemoveEmptyMarker<-function(MAT)
  {Tot<-colSums(MAT[,1:ncol(MAT)],na.rm=TRUE)
   EmptyMarker<-which(Tot==0)
   if (length(EmptyMarker)>0) {MAT<-MAT[,-EmptyMarker]}  
   MAT}

# RemoveSample (i.e. rows of X where the sample name (column 1 of X) is given by a list of names Y)
RemoveSample<-function(X,Y) # function that removes rows of X that have the sample name (col 1) given in a list of names given in Y 
 {for (i in 1:length(Y)) 
   {which(Y[i]==X[,1])->Z; X<-X[-Z,]}
  X}  

# SaveMatrix
SaveMatrix<-function(MAT,stepABC)
  {write.table(MAT, file=paste(paste(as.vector(PARAM[(PARAM[,1]=='Species'),2]),as.vector(PARAM[(PARAM[,1]=='Primers'),2]),stepABC,sep='_'),'txt',sep='.'), append=F, quote=F, sep='\t', row.names=T, col.names=T, na='NA', dec='.')}


#-------------------------------------------------------------------------------------------------------------------------
# Analysis of the data set
#-------------------------------------------------------------------------------------------------------------------------


#################################
#   step A:  starting point     #
#################################

  # Order profiles by increasing sample names
  MATRIX[order(MATRIX[,1],na.last=T,decreasing=F),]->MATRIX
 
  # Create subsets of the whole matrix with SIZE only and HEIGHT only
  NbB<-((ncol(MATRIX))-1)/2  # number of bins stemming from the GeneMapper treatment
  NbI<-nrow(MATRIX) # number of samples
  as.vector(MATRIX[,1])->IND # names of samples
  MATRIX[,2:(NbB+1)]->SIZE
  IND->row.names(SIZE)
  MATRIX[,(1+NbB+1):ncol(MATRIX)]->HEIGHT  
  IND->row.names(HEIGHT)
  
  # Remove first empty bins
  RemoveEmptyMarker(SIZE)->SIZE
  RemoveEmptyMarker(HEIGHT)->HEIGHT
  NbB<-ncol(SIZE)
    
  # Give marker's names (format: Species_PrimerCombination_length, example: Aal_EAATMCAC_82.5)
  Mean.Size<-rep(NA,NbB)
  NamesAlleles<-rep(NA,NbB)
  for (i in 1:NbB) {round(mean(SIZE[(SIZE[,i]>0),i],na.rm=T), digits=1)->Mean.Size[i]}
  for (i in 1:NbB) {NamesAlleles[i]<-paste(as.vector(PARAM[(PARAM[,1]=='Species'),2]),as.vector(PARAM[(PARAM[,1]=='Primers'),2]),Mean.Size[i],sep="_")} 
  colnames(SIZE)<-NamesAlleles
  colnames(HEIGHT)<-NamesAlleles
  
  # Name of the file summaring all step of the procedure
  filename<-paste(as.vector(PARAM[(PARAM[,1]=='Species'),2]),as.vector(PARAM[(PARAM[,1]=='Primers'),2]),"log.txt",sep="_")
  
  # PRE.MATRIX.A
  DIMNAMES<-list(IND,NamesAlleles)
  PRE.MATRIX.A<-matrix(NA,nrow=NbI,ncol=NbB,dimnames=DIMNAMES)
  as.numeric(as.vector(PARAM[(PARAM[,1]=='TresholdA1'),2]))->TA1
  for (i in 1:NbB) {as.numeric(HEIGHT[,i]>TA1)->PRE.MATRIX.A[,i]} # when height is higher than the TresholdA1, a '1' is added in the matrix A (else it's a '0')                                                                  

  # Error rates after GeneMapper scoring (in MATRIX.A)
  ErrorRates(PRE.MATRIX.A,CONTROLS,PARAM,DeleteMarker=F,DeleteControls=T)->OutputErrorRatesA

  # MATRIX.A
  OutputErrorRatesA[[10]]->MATRIX.A
  
  # Description of markers in the MATRIX.A
  Stats(MATRIX.A)[[1]]->InfoMatrixA  # table with information about markers in the MATRIX.A
   
  # Save MATRIX.A (samples (without controls) and without monomorphic "0" markers)
  SaveMatrix(MATRIX.A,'A')

  # Write details about MATRIX.A
  write(c("============================== scanAFLP v1.0 ==============================","\n=================> Parameters\n"),file=filename, append=F)
  write.table(PARAM,file=filename, append=T, row.names=F, col.names=F, sep='\t', quote=F, na="NA", dec=".")
  write("\n=================> Step A\n",file=filename, append=T)
  write.table(InfoMatrixA,file=filename, append=T, row.names=T, col.names=F, sep='\t', quote=F, na="NA", dec=".")
  write(paste("\nMismatch error rate in duplicated samples:",OutputErrorRatesA[[1]],sep=' '),file=filename, append=T)
  write(paste("Mismatch error rate in multiple controls:",OutputErrorRatesA[[2]],sep=' '),file=filename, append=T)
  write(paste("Global mismatch error rate:",OutputErrorRatesA[[3]],sep=' '),file=filename, append=T)

###################################
#  step B: Bins/Markers quality   #
###################################

  as.numeric(as.vector(PARAM[(PARAM[,1]=='TresholdB1'),2]))->T1
  as.numeric(as.vector(PARAM[(PARAM[,1]=='PctgB2'),2]))->T2
  as.numeric(as.vector(PARAM[(PARAM[,1]=='CVB3'),2]))->T3
  as.numeric(as.vector(PARAM[(PARAM[,1]=='TresholdB4'),2]))->T4

  # Remove peaks below TresholdB1 to remove noise    
  for (j in 1:ncol(HEIGHT)) {SIZE[HEIGHT[,j]<T1,j]<-0;HEIGHT[HEIGHT[,j]<T1,j]<-0} 
                   
  # Peaks unique and below < TresholdB4 will be removed (the height of the unique peak becomes 0)
  for (j in 1:(ncol(HEIGHT))) {
                              if (length(((length(HEIGHT[((HEIGHT[,j])>0),j])==1)&((HEIGHT[((HEIGHT[,j])>0),j])<T4)))!=0)
                                {if ((length(HEIGHT[((HEIGHT[,j])>0),j])==1)&((HEIGHT[((HEIGHT[,j])>0),j])<T4)) 
                                      {HEIGHT[((HEIGHT[,j])>0),j]<-0}
                                }
                              } 
                              
  # For each marker, decision to select (T) or remove it (F)
  Bilan.Tri<-matrix(T,nr=ncol(MATRIX.A),nc=2)
  Bilan.Tri[,1]<-colnames(MATRIX.A)
  
  for (j in 1:(ncol(HEIGHT)))
                   {
                   Y<-HEIGHT[((HEIGHT[,j])>0),j]                   
                   if (length(Y)==0) {Bilan.Tri[j,2]<-F}
                   if (length(Y)==1) {Bilan.Tri[j,2]<-T}
                   if ((length(Y)>1)&(max(Y)<T1)) {Bilan.Tri[j,2]<-F}
                   if (length(Y)>1&(max(Y)>T1))
                              {                              
                              XX<-data.frame(table(cut(Y,seq((min(Y)-1),(max(Y)+1),by=T1))))
                              max(XX[,2])->Z
                              which(XX[,2]==Z)->Num.Classe.Max                            
                              (seq(min(Y),max(Y),by=T1)[Num.Classe.Max]+(seq(min(Y),max(Y),by=T1)[Num.Classe.Max+1]))/2->Max.Freq.Height
                              
                              if (XX[(XX[,2]==Z),1]==XX[1,1]) {HEIGHT[HEIGHT[,j]<(min(Y)+T1),j]<-0} # Put "0" when peaks are in the lowest class when the maximum of the heights of markers are in this class                                         
                              Y<-HEIGHT[((HEIGHT[,j])>0),j] # update the new Y
                              
                              #######################
                              # Absolute treshold   #
                              #######################
  
                              if (length(Y)==0) {Bilan.Tri[j,2]<-F} 
                              if (length(Y)==1) {Bilan.Tri[j,2]<-T}                 
                              if (length(Y)>1) 
                                     {
                                     # To find the new maximum of frequencies of heights to see if the maximum is still the new first class
                                     XXX<-data.frame(table(cut(Y,seq((min(Y)-1),(max(Y)+1),by=T1))))
                                     max(XXX[,2])->Z
                                     which(XXX[,2]==Z)->Num.Classe.Max2
                                     
                                     if ((length(seq(min(Y),max(Y),by=T1)))==1) {Max.Freq.Height<-0
                                                                                 Bilan.Tri[j,2]<-F} 
                                     if ((length(seq(min(Y),max(Y),by=T1)))>1) 
                                     {seq(min(Y),max(Y),by=T1)[Num.Classe.Max2]->limInf
                                      seq(min(Y),max(Y),by=T1)[Num.Classe.Max2+1]->limSup
                                     if (is.na(limSup)!=T) {(limInf+limSup)/2->Max.Freq.Height} else {limInf->Max.Freq.Height}
                                     if (XXX[(XXX[,2]==Z),1]==XXX[1,1]) {HEIGHT[HEIGHT[,j]<(min(Y)+T1),j]<-0}
                                     Y<-HEIGHT[((HEIGHT[,j])>0),j] # update the new Y
                                     if (length(Y)==0) {Bilan.Tri[j,2]<-F} 
                                     if (length(Y)==1) {Bilan.Tri[j,2]<-T}                
                                     if (length(Y)>1)
                                                {
                                                #####################################################################
                                                # Treshold to exclude peaks really smaller than others              #
                                                #####################################################################
                      
                                                T2bis<-(Max.Freq.Height[1]*T2) # In case of several maximum of frequencies we look only the first (lowest height) to calculate the treshold 2
                                                if (length(HEIGHT[(HEIGHT[,j]<T2bis),j])>0) {HEIGHT[(HEIGHT[,j]<T2bis),j]<-0}
                                                Y<-HEIGHT[((HEIGHT[,j])>0),j] # update the new Y
                                                if (length(Y)==0) {Bilan.Tri[j,2]<-F}
                                                if (length(Y)==1) {Bilan.Tri[j,2]<-T}                
                                                if (length(Y)>1)
                                                          {
                                                          #################################################################
                                                          # Coefficient of Variation (standard deviation/mean)            #
                                                          #################################################################

                                                          CV<-(sd(HEIGHT[HEIGHT[,j]>0,j])/(mean(HEIGHT[HEIGHT[,j]>0,j])))
                                                          if (CV>T3) {Bilan.Tri[j,2]<-F} else {Bilan.Tri[j,2]<-T} # Markers that have a CV > than T3 will be removed
                                                          
                   }}}}}}

  # PRE.MATRIX.B
  HEIGHT[,as.logical(Bilan.Tri[,2])]->PRE.MATRIX.B
  for (j in 1:ncol(PRE.MATRIX.B)) {PRE.MATRIX.B[PRE.MATRIX.B[,j]>0,j]<-1} 
  
  # Names of removed markers
  names(HEIGHT)[which(as.logical(Bilan.Tri[,2])==F)]->NamesDelMarkers

  # Error rates in MATRIX .B
  ErrorRates(PRE.MATRIX.B,CONTROLS,PARAM,DeleteMarker=F)->OutputErrorRatesB

  # MATRIX.B
  OutputErrorRatesB[[10]]->MATRIX.B
  
  # Description of markers in the MATRIX.B
  Stats(MATRIX.B)[[1]]->InfoMatrixB  # table with information about markers in the MATRIX.B
   
  # Save MATRIX.B (samples (without controls) and without monomorphic "0" markers)
  SaveMatrix(MATRIX.B,'B')

  # Write details about MATRIX.B
  write("\n=================> Step B\n",file=filename, append=T)
  write.table(InfoMatrixB,file=filename, append=T, row.names=T, col.names=F, sep='\t', quote=F, na="NA", dec=".")
  write(paste("\nMismatch error rate in duplicated samples:",OutputErrorRatesB[[1]],sep=' '),file=filename, append=T)
  write(paste("Mismatch error rate in multiple controls:",OutputErrorRatesB[[2]],sep=' '),file=filename, append=T)
  write(paste("Global mismatch error rate:",OutputErrorRatesB[[3]],sep=' '),file=filename, append=T)
  write(c("\nNames of removed markers",NamesDelMarkers),file=filename, append=T)  

#################################################
# Step C: Repeteability, mismatch error rates   #
#################################################

  # PRE.MATRIX.C
  ErrorRates(PRE.MATRIX.B,CONTROLS,PARAM,DeleteMarker=T,DeleteControls=F)->OutputErrorRatesPreC
  OutputErrorRatesPreC[[10]]->PRE.MATRIX.C

  # Error rates in MATRIX.C
  ErrorRates(PRE.MATRIX.C,CONTROLS,PARAM,DeleteMarker=F,DeleteControls=T)->OutputErrorRatesC

  # MATRIX.C
  OutputErrorRatesC[[10]]->MATRIX.C
  
  # Description of markers in the MATRIX.C
  Stats(MATRIX.C)[[1]]->InfoMatrixC  # table with information about markers in the MATRIX.C
   
  # Save MATRIX.C (samples (without controls) and without monomorphic "0" markers)
  SaveMatrix(MATRIX.C,'C')

  # Write details about MATRIX.C
  write("\n=================> Step C\n",file=filename, append=T)
  write.table(InfoMatrixC,file=filename, append=T, row.names=T, col.names=F, sep='\t', quote=F, na="NA", dec=".")
  write(paste("\nMismatch error rate in duplicated samples:",OutputErrorRatesC[[1]],sep=' '),file=filename, append=T)
  write(paste("Mismatch error rate in multiple controls:",OutputErrorRatesC[[2]],sep=' '),file=filename, append=T)
  write(paste("Global mismatch error rate:",OutputErrorRatesC[[3]],sep=' '),file=filename, append=T)
  write(c('\n',OutputErrorRatesPreC[[4]]),file=filename, append=T)  
  write(OutputErrorRatesPreC[[5]],file=filename, append=T)  
  write(OutputErrorRatesPreC[[6]],file=filename, append=T)  
  write(OutputErrorRatesPreC[[7]],file=filename, append=T)  
  write(OutputErrorRatesPreC[[8]],file=filename, append=T)  
  write(OutputErrorRatesPreC[[9]],file=filename, append=T)  
}
# END