/***************************************************************************
*   Copyright (C) 2007 by Faubet Pierre   *
*   pierre.faubet@e.ujf-grenoble.fr   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef WIZARD_H
#define WIZARD_H

#include <QWizard>
#include <QWizardPage>

class QCheckBox;
class QLabel;
class QLineEdit;
class QRadioButton;
class QCompleter;
class QGroupBox;
class QToolButton;
class QSpinBox;
class QDoubleSpinBox;
class QFrame;
class QString;

/**
 * This class implements BIMr wizard
 * @author Pierre Faubet <pierre.faubet@e.ujf-grenoble.fr>
 */
class Wizard : public QWizard
  {
    Q_OBJECT

  public:
    enum { Page_Intro, Page_Input, Page_Settings, Page_Output,Page_StartRuns,Page_OpenProject };

    Wizard(QWidget *parent = 0);

  private slots:
    void showHelp();
  };

class TitlePage : public QWizardPage
  {
    Q_OBJECT

  public:
    TitlePage(QWidget *parent = 0);

    int nextId() const;

  private:
    QGroupBox *groupBox;
    QRadioButton *StartradioButton;
    QRadioButton *loadradioButton;
  };

class InputPage : public QWizardPage
  {
    Q_OBJECT

  public:
    InputPage(QWidget *parent = 0);

    int nextId() const;

  private slots:
    void getFilename();

  private:
    bool isComplete() const;

    QGroupBox *groupBox;
    QLabel *Inputgenlabel;
    QLineEdit *InputgenlineEdit;
    QToolButton *InputgentoolButton;
    QGroupBox *FactorsgroupBox;
    QLabel *Inputfactlabel;
    QLineEdit *InputfactlineEdit;
    QToolButton *InputfacttoolButton;
    QCheckBox *WithinteractioncheckBox;
    QCompleter *completer;
  };

class SettingsPage : public QWizardPage
  {
    Q_OBJECT

  public:

    SettingsPage(QWidget *parent = 0);

    void initializePage();

    int nextId() const;

  private slots:
    void setEnabled();

  private:
    QGroupBox *SettingsgroupBox;
    QLabel *Burninlabel;
    QLineEdit *SampleSizelineEdit;
    QLineEdit *BurninlineEdit;
    QSpinBox *NbRepspinBox;
    QLabel *NbReplabel;
    QLabel *Thininglabel;
    QLineEdit *ThininglineEdit;
    QLabel *SampleSizelabel;
    QGroupBox *AdancedgroupBox;
    QCheckBox *useFmodelcheckBox;
    QCheckBox *useRJMCMCcheckBox;
    QGroupBox *PilotrungroupBox;
    QLabel *Nbpilotlabel;
    QSpinBox *NbpilotspinBox;
    QSpinBox *PilotlengthspinBox;
    QLabel *Pilotlengthlabel;
    QGroupBox *PriorgroupBox;
    QDoubleSpinBox *b_taudoubleSpinBox;
    QLabel *a_taulabel;
    QDoubleSpinBox *s2_alphadoubleSpinBox;
    QLabel *s2alphalabel;
    QDoubleSpinBox *a_taudoubleSpinBox;
    QLabel *b_taulabel;
    QFrame *line_2;
    QLabel *psilabel;
    QDoubleSpinBox *psidoubleSpinBox;
    QFrame *line_3;
    QDoubleSpinBox *xidoubleSpinBox;
    QLabel *omegalabel;
    QDoubleSpinBox *omegadoubleSpinBox;
    QLabel *lambdalabel;
    QLabel *xilabel;
    QDoubleSpinBox *lambdadoubleSpinBox;
    QGroupBox *ProposalgroupBox;
    QLabel *s2_psilabel;
    QDoubleSpinBox *s2thetadoubleSpinBox;
    QLabel *e_Flabel;
    QLabel *s2thetalabel;
    QDoubleSpinBox *e_mdoubleSpinBox;
    QDoubleSpinBox *e_nmdoubleSpinBox;
    QDoubleSpinBox *s2psidoubleSpinBox;
    QLabel *e_plabel;
    QDoubleSpinBox *e_pdoubleSpinBox;
    QDoubleSpinBox *e_FdoubleSpinBox;
    QLabel *e_mlabel;
    QLabel *e_nmlabel;
  };

class OutputPage : public QWizardPage
  {
    Q_OBJECT

  public:

    OutputPage(QWidget *parent = 0);

    void initializePage();
    int nextId() const;

  private:
    QGroupBox *RawMCMCgroupBox;
    QCheckBox *migcheckBox;
    QCheckBox *loglikcheckBox;
    QCheckBox *mcheckBox;
    QCheckBox *regcheckBox;
    QCheckBox *pcheckBox;
    QCheckBox *FcheckBox;
    QCheckBox *fstcheckBox;
    QCheckBox *ptildcheckBox;
    QGroupBox *PosteriorstatgroupBox;
    QCheckBox *sdcheckBox;
    QCheckBox *MtcheckBox;
    QCheckBox *PopcheckBox;
    QCheckBox *psicheckBox;
  };

class FinishPage : public QWizardPage
  {
    Q_OBJECT

  public:
    FinishPage(QWidget *parent = 0);

    int nextId() const;

  private:
    QFrame *frame;
    QLabel *label;
    QRadioButton *YesradioButton;
    QRadioButton *NoradioButton;
  };

class OpenPage : public QWizardPage
  {
    Q_OBJECT

  public:
    OpenPage(QWidget *parent = 0);

    int nextId() const;

  private slots:
    void getFilename();

  private:
    bool isComplete() const;

    QFrame *frame;
    QLabel *projectfilelabel;
    QLineEdit *projectfilelineEdit;
    QToolButton *projectfiletoolButton;
    QCompleter *completer;
  };

#endif
