/***************************************************************************
 *   Copyright (C) 2007 by Faubet Pierre   *
 *   pierre.faubet@e.ujf-grenoble.fr   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PLOT_H
#define PLOT_H

#include <QString>

#include <qwt_plot.h>
#include <qwt_scale_widget.h>
#include <qwt_scale_draw.h>
#include <qwt_plot_grid.h>
#include <qwt_plot_curve.h>

#include <gsl/gsl_histogram.h>

#include "histogram_item.h"
#include "scrollzoomer.h"

const unsigned int c_rangeMax = 1000;

class Zoomer: public ScrollZoomer
  {
  public:
    Zoomer(QwtPlotCanvas *canvas):
        ScrollZoomer(canvas)
    {}

    virtual void rescale()
    {
      QwtScaleWidget *scaleWidget = plot()->axisWidget(yAxis());
      QwtScaleDraw *sd = scaleWidget->scaleDraw();

      int minExtent = 0;
      if ( zoomRectIndex() > 0 )
        {
          // When scrolling in vertical direction
          // the plot is jumping in horizontal direction
          // because of the different widths of the labels
          // So we better use a fixed extent.

          minExtent = sd->spacing() + sd->majTickLength() + 1;
          minExtent += sd->labelSize(
                         scaleWidget->font(), c_rangeMax).width();
        }

      sd->setMinimumExtent(minExtent);

      ScrollZoomer::rescale();
    }
  };
  
/**
* This class implements plotting features
* @author Pierre Faubet <pierre.faubet@e.ujf-grenoble.fr>
 */
class Plot : public QwtPlot
  {
  public:

    enum plot_t {Trace,Runningmean,Density,Histogram,Empty};

    QwtPlotCurve *cCurve;
    Zoomer *zoomer;
    QwtPlotGrid *grid;
    HistogramItem *histogram;

    QString header;

  public:
    Plot(QWidget *parent);
    ~Plot();
    void TracePlot(double *x,double *y,int size,QString title);
    void HistogramPlot(double *x,int size,QString title,int nbbins,double lb,double ub);
    void DensityPlot(double *x,double *y,int size,QString title);
    void RunningmeanPlot(double *x,double *y,int size,QString title);
    void clear();

  private:
    plot_t plotType;
  };
#endif
