//
// C++ Implementation: 
//
// Description: 
//
//
// Author: Faubet Pierre <pierre.faubet@e.ujf-grenoble.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <QFile>
#include <QUrl>
#include <QDesktopServices>
#include <QPalette>

#include "uiabout.h"

UIAbout::UIAbout(QWidget* parent, Qt::WFlags fl)
: QDialog( parent, fl ), Ui::AboutDialog()
{
	setupUi(this);
	connect( AbouttextBrowser, SIGNAL( anchorClicked( const QUrl& ) ), this, SLOT( anchorClicked( const QUrl& ) ) );
}

UIAbout::~UIAbout()
{
}

/*$SPECIALIZATION$*/
void UIAbout::anchorClicked( const QUrl& url )
{
	QTextBrowser* browser = qobject_cast<QTextBrowser*>( sender() );
	browser->setHtml( browser->toHtml() );
	QDesktopServices::openUrl( url );
}

void UIAbout::setPixmap(QString pathtoPixmap)
{
	label->setPixmap(QPixmap(pathtoPixmap));
}

void UIAbout::setText(QString pathtoText)
{
	QFile file;
	file.setFileName( pathtoText );
	file.open( QFile::ReadOnly | QFile::Text );
	AbouttextBrowser->setHtml( file.readAll() );
	file.close();	
}
