/***************************************************************************
 *   Copyright (C) 2007 by Faubet Pierre   *
 *   pierre.faubet@e.ujf-grenoble.fr   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef RAWDATA_H
#define RAWDATA_H

#include <QReadWriteLock>
#include <string>

using namespace std;
//
/**
 * This class implements raw data handling and statistical features
 * @author Pierre Faubet <pierre.faubet@e.ujf-grenoble.fr>
 */
class RawData
  {

  public:
    RawData(string filename,int column,int size);
    RawData(string filename,int filter,int column,int size);
    ~RawData();

    enum kernel_t {Epanechnikov,Triangular,Gaussian,Boxcar,Null};

    void getStatistics(int burnin = 0,int burnout = 0);
    void getKde(kernel_t kernel=Gaussian,double adjust = 1,int burnin = 0,int burnout = 0);
    void getHpdi(double alpha = 0.05);
    static int N;

  private:
    double *iter;
    double *obs;
    double *x_kde;
    double *y_kde;
    int n;
    string colname;
    double kde(double x_i,kernel_t k_t,double bandwidth, double *x, int size);
    double min,max,mean,sd,h0,mode,hpdilo,hpdihi;
    static QReadWriteLock lock ;

  friend class MainWindowImpl;

};
#endif
