/***************************************************************************
 *   Copyright (C) 2007 by Faubet Pierre   *
 *   pierre.faubet@e.ujf-grenoble.fr   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MCMCTHREAD_H
#define MCMCTHREAD_H

#include <QThread>
#include <QMutex>

#include "mcmc.h"

/**
 * This class implements threads for MCMC runs
 * @author Pierre Faubet <pierre.faubet@e.ujf-grenoble.fr>
 */
class MCMCThread : public QThread
  {
    Q_OBJECT

  public:
    MCMCThread(QObject *parent = 0);
    ~MCMCThread();
    void run(); // this is virtual method, we must implement it in our subclass of QThread

  signals:
    void statusChanged(int run,QString status);
    void acceptanceChanged(int run,int length,double nm_acc,double m_acc, double Mt_acc,double F_acc,double p_acc,double theta_acc,double pglob_acc,double psi_acc,double Rj_acc);
    void progressChanged(int run,double progress);
    void samplesizeChanged(int run,double dev);

  public slots:
    void kill();

  private:
    MCMC *mcmc; /**< MCMC run */
    static QMutex mutex;
  };
#endif
