/***************************************************************************
 *   Copyright (C) 2007 by Faubet Pierre   *
 *   pierre.faubet@e.ujf-grenoble.fr   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MAINWINDOWIMPL_H
#define MAINWINDOWIMPL_H
//

#include "ui_mainwindow.h"
#include "wizard.h"
#include "mcmcthread.h"
#include "plot.h"
#include "rawdata.h"

/**
 * This class implements the GUI for BIMr
 * @author Pierre Faubet <pierre.faubet@e.ujf-grenoble.fr>
  */
class MainWindowImpl : public QMainWindow, public Ui::MainWindow
  {
    Q_OBJECT
  public:
    MainWindowImpl( QWidget * parent = 0, Qt::WFlags f = 0 ); /**< Main window of BIMr */
    
  private slots:

    /** Display file conversion utility */
    void displayConverter();

    /** Open documentation in the usual web browser */
    void displayManual();

    /** Show BIMr credits */
    void About();

    /** Start context help */
    void whatsthis();

    /** Prepare new MCMC analyses */
    void displayNewAnalysis();

    /** Import previous results */
    void displayLoadResults();

    /** Show inputfile dialog */
    void displayInputFileDialog();

    /** Show MCMC setting file dialog */
    void displaySettingsDialog();

    /** Show output option dialog */
    void displayOutputDialog();

    /** Read and write raw MCMC file headers */
    void writeParameterNames();

    /** Read MCMC data */
    void setRawData();

    /** Display statistics */
    void setStatistics();

    /** Draw a plot */
    void makePlot();

    /** Compute HPDI */
    void updateHPDI(int conf);

    /** Compute kernel density estimates */
    void updateDensity();

    /** Compute histogram */
    void updateHist();

    /** Reset burnin and/or burnout */
    void resetSliders();

    /** Discard first iterations */
    void setBurnin();

    /** Discard last iterations */
    void setBurnout();

    /** Current sample */
    void reloadRawData();

    /** Stop MCMC runs */
    void killJob();

    /** Load project */
    void loadProject();
    
    void readProjectFile();
    
    void saveSettings();

    /** Exit application */
    void quit();

    /** End current session, start a new one */
    void close();

    /** Read MCMC settings */
    void acceptSettings();

    /** Perform analyses */
    void runMCMC();

    /** Thread survey, current MCMC states */
    void updateThreads();

    /** Save posterior statistics */
    void saveTable();

    /** Save figures */
    void savePlot();

    /** Reload status and sample */
    void refresh();

    /** Write parameter names in combo boxes */
    void fillComboBoxes_and_Tables();

    /** Enable connection with the plot frame */
    void setPlotStatConnections();

    /** Display regression parameter estimates */
    void print_regression_estimates();

    /** Display posterior model probabilities */
    void print_model_estimates();

    /** Display posterior estimates */
    void print_posterior_estimates();

    /** Currnet status
    * @param run an MCMC run
    * @param status its status
    */
    void updateStatus(int run,QString status);

    /** Running acceptance rates
    * @param run an MCMC run
    * @param length ... current iteration and number of accepted values
    */
    void updateAcceptance(int run,int length,double nm_acc,double m_acc, double Mt_acc,double F_acc,double p_acc,double theta_acc,double pglob_acc,double psi_acc,double Rj_acc);

    /** Progress
    * @param run an MCMC run
    * @param progress its progress
    */
    void updateProgress(int run,double progress);

    /** Current sample size and deviance
    * @param  run an MCMC run
    * @param dev its deviance
    */
    void updateSize(int run,double dev);

  private:
    QString projectFilename; /**< Project filename */

    int nbreplicates; /**< Number of MCMC runs */

    int R;
    
    Wizard *wizard; /**< BIMr wizard */

    MCMCThread **mcmcThread; /**< MCMCs */
    int runningThreads; /**< Number of running MCMCs */

    int *sampleSizes; /**< Current sample sizes */

    QVBoxLayout *PlotframeLayout;
    Plot::Plot *plot; /**< Plot */
    RawData *rawdata; /**< Raw MCMC data */
    
    bool is_a_valid_model(int M);
  };
#endif







