/***************************************************************************
 *   Copyright (C) 2007 by Faubet Pierre   *
 *   pierre.faubet@e.ujf-grenoble.fr   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "gamm.h"

/* Returns log of function gamma for argument xx > 0 */
double gsl_sf_lngamma(double xx)
{
  double x, y, tmp, ser;
  static double cof[6] = { 76.18009172947146, -86.50532032941677,
                           24.01409824083091, -1.231739572450155,
                           0.1208650973866179e-2, -0.5395239384953e-5
                         };
  int j;

  y = x = xx;
  tmp = x + 5.5;
  tmp -= (x + 0.5) * log (tmp);
  ser = 1.000000000190015;
  for (j = 0; j <= 5; j++)
    ser += cof[j] / ++y;

  return -tmp + log (2.5066282746310005 * ser / x);
}

/* End of function gsl_sf_lngamma */

/* Return ln(n!) */
double factln(int k)
{
  static double a[101];

  if (k <= 1)
    return 0.0;
  if (k <= 100)
    return a[k] ? a[k] : (a[k] = gsl_sf_lngamma(k + 1.0));
  else
    return gsl_sf_lngamma(k + 1.0);
}
